/* -*- Mode:C; Tab-width:4 -*- */
/*------------------------------------------------------------------------------

	  Sample.r	-  Resources for the Sample Application

	  Copyright Apple Computer, Inc. 1985-1987
	  All rights reserved.

------------------------------------------------------------------------------*/

#include "Types.r"
#include "SysTypes.r"
include "traps";

/* These define's are used in the MENU resources to disable specific
   menu items. */
#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define MenuItem1	0b00001
#define MenuItem2	0b00010
#define MenuItem3	0b00100
#define MenuItem4	0b01000
#define MenuItem5	0b10000

resource 'WIND' (128, "Sample Window") {
	{64, 60, 314, 460},
	documentProc, visible, noGoAway, 0x0, "Sample Window"
};

/* sbw 12/11/89 removed size resource type definition, use mpw 3.0's instead */

resource 'SIZE' (-1) {
		dontSaveScreen, 				/* Save screen			*/
		acceptSuspendResumeEvents,		/* suspend-resume		*/
		enableOptionSwitch,				/* Options switch		*/
		canBackground,					/* accept Juggler background	*/
		multiFinderAware,				/* Juggler aware		*/
		backgroundAndForeground,		
		dontGetFrontClicks,				/* ignore user 'bring to front' clicks */
		ignoreChildDiedEvents,			/* used by debuggers	*/
		not32BitCompatible,				/* maybe in 7.0			 */
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		reserved,
		500000,							/* size 				*/
		467232							/* min size - 32k		*/
};

resource 'DLOG' (128, "About LispM") {
	{66, 102, 224, 400},
	dBoxProc, visible, noGoAway, 0x0, 128, ""
};

resource 'DITL' (128) {
	 {
/* 1 */ {130, 205, 150, 284},
		button {
			enabled,
			"Continue"
		};
/* 2 */ {104, 144, 120, 293},				/*  Author Item */
		staticText {
			disabled,
			""
		};
/* 3 */ {88, 144, 105, 293},				/*  SourceLanguage Item */
		staticText {
			disabled,
			""
		};
/* 4 */ {8, 32, 26, 273},
		staticText {
			disabled,
			"LispMachine in the Macintosh II"
		};
/* 5 */ {32, 80, 50, 212},
		staticText {
			disabled,
			"------------------"
		};
/* 6 */ {56, 16, 74, 281},
		staticText {
			enabled, "Copyright  1987 Texas Instruments"
		};
/* 7 */ {88, 16, 104, 144},
		staticText {
			enabled, "Source Language:"
		};
/* 8 */ {104, 16, 120, 144},
		staticText {
			enabled, "Brought to you by:"
		}
	}
};

resource 'MENU' (128, "Apple", preload) {
	128, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, apple,
	{
		"About LispM",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (129, "File", preload) {
	129, textMenuProc,
	allEnabled,
	enabled, "File",
	{
		"Quit",
			noicon, noKey, nomark, plain
	}
};

resource 'MENU' (130, "Edit", preload) {
	130, textMenuProc,
	AllItems & ~(MenuItem1 | MenuItem2),	/* Disable items #1 & #2 */
	enabled, "Edit",
	 {
		"Undo",
			noicon, "Z", nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Cut",
			noicon, "X", nomark, plain;
		"Copy",
			noicon, "C", nomark, plain;
		"Paste",
			noicon, "V", nomark, plain;
		"Clear",
			noicon, nokey, nomark, plain
	}
};


type 'TIMX' as 'STR ';						/* ab 11/8/88.  */

resource 'TIMX' (0) {
	"microExplorer RPC Call Example"
};

data 'ICN#' (128) { /* TI Bug ICON....Keith 1/27/88 */
	$"0000 0000 007F 0000 007F 0000 007F 0000" 
	$"007F 0000 007F 0000 007F 0C00 007F 1E00" 
	$"007F CCF0 007F C1F8 007F DDF8 007F DDF8" 
	$"007E 1C38 7FFC 1C78 7FFC 187C 3FFF BBFE" 
	$"1FFF BBFE 0FFF BBFE 07FF 3BFE 03FF 33FE" 
	$"03E7 77FE 01C3 00FC 0003 01F0 0003 83C0" 
	$"0003 FF80 0001 FF00 0001 FE00 0000 FE00" 
	$"0000 7E00 0000 3F00 0000 0F00 0000 0000" 
	$"00FF 8000 00FF 8000 00FF 8000 00FF 8000" 
	$"00FF 8000 00FF 8C00 00FF 9E00 00FF FFF0" 
	$"00FF EFF8 00FF FFFC 00FF FFFC 00FF FFFC" 
	$"FFFF FFFC FFFE 1CFC FFFF FFFE 7FFF FFFF" 
	$"3FFF FFFF 1FFF FFFF 0FFF BFFF 07FF BFFF" 
	$"07FF FFFF 03E7 8FFE 01C7 83FC 0007 FFF0" 
	$"0007 FFC0 0003 FF80 0003 FF00 0001 FF00" 
	$"0000 FF00 0000 7F80 0000 3F80 0000 0F00" 
};

resource 'BNDL' (128) {
	'TIMX',					/* ab 11/8/88.  */
	0,
	{
		'ICN#',
		{
			0, 128
		},
		'FREF',
		{
			0, 128
		}
	}
};


resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'ALRT' (128) {
	{28, 138, 228, 378},
	910,
	{	/* array: 4 elements */
		/* [1] */
		OK, visible, sound1;
		/* [2] */
		OK, visible, sound1;
		/* [3] */
		OK, visible, sound1;
		/* [4] */
		OK, visible, sound1
	}
};

resource 'DITL' (910) {
	{	/* array DITLarray: 3 elements */
		/* [1] */
		{126, 150, 146, 213},
		Button {
			enabled,
			"Continue"
		};
		/* [2] */
		{49, 11, 66, 207},
		StaticText {
			disabled,
			"^0"
		};
		/* [3] */
		{68, 52, 88, 130},
		StaticText {
			disabled,
			"^1"
		}
	}	
};

data 'ALRT' (260) {
	$"0054 005E 013A 0230 0104 CCCC"                  /* .T.^.:.0.. */
};

data 'DITL' (260) {
	$"0002 0000 0000 00B7 000B 00CB 0047 0402"        /* ...........G.. */
	$"4F4B 0000 0000 0007 005A 0058 01AB 0804"        /* OK.......Z.X... */
	$"5E30 5E31 0000 0000 005E 005C 00B6 01AC"        /* ^0^1.....^.\.. */
	$"0804 5E32 5E33"                                 /* ..^2^3 */
};

data 'NAME' (0, "Application-name") {
	$"1354 423A 3A72 7063 2D61 7070 6C69 6361"        /* .TB::rpc-applica */
	$"7469 6F6E"                                      /* tion */
};
